//AIM:Computation of N-Point DFT using DIF method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={1,2,3,4,5,6,7,8,9}
//using DIF(Split radix) method for N=9(3*3)
//For understanding,let us write the given data as
//x(0)=1;x(1)=2,x(2)=3,x(3)=4,x(4)=5,x(5)=6,x(6)=7,x(7)=8,x(8)=9
x0=1;//DIF-FFT,so arranging the input in natural order
x1=2;//DIF-FFT,so arranging the input in natural order
x2=3;//DIF-FFT,so arranging the input in natural order
x3=4;//DIF-FFT,so arranging the input in natural order
x4=5;//DIF-FFT,so arranging the input in natural order
x5=6;//DIF-FFT,so arranging the input in natural order
x6=7;//DIF-FFT,so arranging the input in natural order
x7=8;//DIF-FFT,so arranging the input in natural order
x8=9;//DIF-FFT,so arranging the input in natural order

//Computing the twiddle factors
W0=cos((2*%pi/9)*0)-(sqrt(-1))*sin((2*%pi/9)*0)
disp(W0,'W0=')
W1=cos((2*%pi/9)*1)-(sqrt(-1))*sin((2*%pi/9)*1)
disp(W1,'W1=')
W2=cos((2*%pi/9)*2)-(sqrt(-1))*sin((2*%pi/9)*2)
disp(W2,'W2=')
W3=cos((2*%pi/9)*3)-(sqrt(-1))*sin((2*%pi/9)*3)
disp(W3,'W3=')
W4=cos((2*%pi/9)*4)-(sqrt(-1))*sin((2*%pi/9)*4)
disp(W4,'W4=')
W5=cos((2*%pi/9)*5)-(sqrt(-1))*sin((2*%pi/9)*5)
disp(W5,'W5=')
W6=cos((2*%pi/9)*6)-(sqrt(-1))*sin((2*%pi/9)*6)
disp(W6,'W6=')
W7=cos((2*%pi/9)*7)-(sqrt(-1))*sin((2*%pi/9)*7)
disp(W7,'W7=')
W8=cos((2*%pi/9)*8)-(sqrt(-1))*sin((2*%pi/9)*8)
disp(W8,'W8=')

//Stage I computations
x0a=x0+x3+x6;
x1b=x1+x4+x7;
x2c=x2+x5+x8;
x3d=x0+x3*W3+x6*W6;//at line 4; x3 & x6 are to be multiplied by twiddle factor W3 and W6 respectively
x4e=x1+x4*W3+x7*W6;//at line 5; x4 & x7 are to be multiplied by twiddle factor W3 and W6 respectively
x5f=x2+x5*W3+x8*W6;//at line 6; x5 & x8 are to be multiplied by twiddle factor W3 and W6 respectively
x6g=x0+x3*W6+x6*W3;//at line 7; x3 & x6 are to be multiplied by twiddle factor W3 and W6 respectively
x7h=x1+x4*W6+x7*W3;//at line 8; x4 & x7 are to be multiplied by twiddle factor W3 and W6 respectively
x8i=x2+x5*W6+x8*W3;//at line 9; x5 & x8 are to be multiplied by twiddle factor W3 and W6 respectively

//Stage-II Computations
X0=x0a+x1b+x2c;
X3=x0a+x1b*W3+x2c*W6;//at line 2; x1b & x2c are to be multiplied by twiddle factor W3 and W6 respectively
X6=x0a+x1b*W6+x2c*W3;//at line 3; x1 & x2c are to be multiplied by twiddle factor W6 and W3 respectively
X1=x3d+x4e*W1+x5f*W2;//at line 4; x4e & x5f are to be multiplied by twiddle factor W1 and W2 respectively
X4=x3d+x4e*W1*W3+x5f*W2*W6;//at line 5; x4e & x5f are to be multiplied by twiddle factor W3,W1 and W2,W6 respectively
X7=x3d+x4e*W1*W6+x5f*W2*W3;//at line 6; x4e & x5f are to be multiplied by twiddle factor W1,W6 and W2,W3 respectively
X2=x6g+x7h*W2+x8i*W4;//at line 7; x7h & x8i are to be multiplied by twiddle factor W2 and W4 respectively
X5=x6g+x7h*W2*W3+x8i*W4*W6;//at line 8; x7h & x8i are to be multiplied by twiddle factor W2,W3 and W4,W6 respectively
X8=x6g+x7h*W2*W6+x8i*W4*W3;//at line 9; x7h & x8i are to be multiplied by twiddle factor W2,W6 and W4,W3 respectively

//Output
disp(X0,'X(0)=')
disp(X3,'X(3)=')
disp(X6,'X(6)=')
disp(X1,'X(1)=')
disp(X4,'X(4)=')
disp(X7,'X(7)=')
disp(X2,'X(2)=')
disp(X5,'X(5)=')
disp(X8,'X(8)=')
disp({X0,X1,X2,X3,X4,X5,X6,X7,X8},'So,the DFT of x(n) using Decimation-in-Frequency Fast Fourier Transform(DIF-FFT) is X(k)=')

//Expected output:X(k)={45,-4.5+12.363648i,-4.5+5.3628912i,-4.5+2.5980762i,-4.5+0.7934714i,-4.5-0.7934714i,-4.5-2.5980762i,-4.5-5.3628912i,-4.5-12.363648i} 
